/*
  *
  * copyright (c) 2013-2024 Heliac Technologies
  * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
  *
  * linee guida per l'utilizzo del logo https://www.geecom.org/?alias=linee-guida-per-luso-del-logo-geecom

  questo file mostra i commenti in una tabella. viene usato nella home page e nella pagina commenti
*/

function aggiungiAlCarrello(tipo,idProdotto,titolo,immagine,prezzo,disponibilita) {
    var idVariazione = 0;
        
    if(disponibilita==0) {
        alert("Questo prodotto non è disponibile al momento");
    }
    else {
        if(tipo=="prodottoEcommerce") {        
            var requestUrl ='controller/ecommerce/controllerCarrello.php?operazione=inserisciProdotto&prodotto='+idProdotto+'&quantitaProdotto=1&idVariazione='+idVariazione;
        }
        else {        
            var requestUrl ='controller/ecommerce/controllerCarrello.php?operazione=inserisciProdottoDropshipping&prodotto='+idProdotto+'&quantitaProdotto=1&titolo='+titolo+"&prezzo="+prezzo+"&idVariazione="+idVariazione;
        }
        
        $.ajax({
            url: requestUrl,
            success: function(text) {
                if(text=="ok") {
                    document.getElementById("immagineProdottoModal").innerHTML = "<img class=\"img-fluid\" src=\""+immagine+"\">";
                    document.getElementById("titoloProdottoModal").innerHTML =titolo;
                    document.getElementById("prezzoProdottoModal").innerHTML ="Prezzo : <strong>"+prezzo+" €</strong>";
                    $('#aggiungi-al-carrello').modal("show");
                    aggiornaLabelCarrello();
                }
                else {
                    alert("c'è stato un problema... riprova tra qualche istante!");
                }
            }
        });
    }
    return false;
}

/*
 *	Funzione per aggiungere un prodotto al carrello dalla pagina del prodotto. Il campo prezzo
 *	viene ricavato da un campo input nascosto peché potrebbe essere stato modificato in base ai
 *	campi input ( esempio la scelta di un attributo)
 */
function aggiungiAlCarrelloPaginaProdotto(tipo,idProdotto,attributo,titolo,immagine,disponibilita,prodottoVariabile) {
    var idVariazione     = 0;
    var valoreAttributi  = "";
    var stringaAttributo = "";
    if(prodottoVariabile=="si") {
    	idVariazione = document.getElementById("variazioneProdotto"+idProdotto).value;
    }
    
    if(attributo!="") {
        var numeroAttributo = 0;
        var arrayAttributi  = attributo.split(",");
        var l = arrayAttributi.length;
        
        for(i=0;i<l;i++) {
            var valoreSingoloAttributo = document.getElementById(arrayAttributi[i]).value;
            
            if(numeroAttributo>0) {            
                valoreAttributi += ", " + arrayAttributi[i]+":"+valoreSingoloAttributo;
            }
            else {
                valoreAttributi += arrayAttributi[i]+":"+valoreSingoloAttributo;
            }
        }
        
        stringaAttributo = "&attributo="+valoreAttributi;
    }
    
    var quantita   = document.getElementById("quantita").value;
    var prezzo     = document.getElementById("inputPrezzoProdotto").value;
    
    if(quantita<=disponibilita) {
        if(tipo=="prodottoEcommerce") {
            var requestUrl ='controller/ecommerce/controllerCarrello.php?operazione=inserisciProdotto&prodotto='+idProdotto+'&quantitaProdotto='+quantita+'&idVariazione='+idVariazione+stringaAttributo;
        }
        else {
            var requestUrl ='controller/ecommerce/controllerCarrello.php?operazione=inserisciProdottoDropshipping&prodotto='+idProdotto+'&quantitaProdotto='+quantita+"&titolo="+titolo+"&prezzo="+prezzo+'&idVariazione='+idVariazione+stringaAttributo;
        }
	
        $.ajax({
             url: requestUrl,
             success: function(text) {
                 if(text=="ok") {
                    document.getElementById("immagineProdottoModal").innerHTML = "<img class=\"img-fluid\" src=\""+immagine+"\">";
                    document.getElementById("titoloProdottoModal").innerHTML =titolo;
                    document.getElementById("prezzoProdottoModal").innerHTML ="Prezzo : <strong>"+prezzo+" €</strong>";
                   $('#aggiungi-al-carrello').modal("show");
                   aggiornaLabelCarrello()
                 }
                 else {
                         alert("c'è stato un problema... riprova tra qualche istante!");
                 }
             }
        });
        return false;
    }
    else if(disponibilita==0) {
	alert("Al momento questo prodotto non è disponibile!");
    }
    else {
	alert("Quantità superiore alle scorte! Disponiamo di massimo "+disponibilita+" pezzi");
    }
}

function aggiornaQuantitaProdotto(idProdotto,quantitaDisponibile,quantitaAttuale,minimoAcquistabile) {
    var quantita = document.getElementById("quantita"+idProdotto).value;
    if(quantita <minimoAcquistabile) {
        alert("Non puoi acquistare meno di "+minimoAcquistabile+" unità di questo prodotto");
        location.href='controller/ecommerce/controllerCarrello.php?operazione=modificaQuantita&prodotto='+idProdotto+'&quantitaProdotto='+minimoAcquistabile;
    }
    else if(quantita <= quantitaDisponibile) {
        location.href='controller/ecommerce/controllerCarrello.php?operazione=modificaQuantita&prodotto='+idProdotto+'&quantitaProdotto='+quantita;
    }
    else {
	alert("Attenzione, la quantità da te richiesta supera la nostra disponibilità");
	document.getElementById("quantita"+idProdotto).value = quantitaAttuale;
    }
    
    return false;
}

function aggiornaSpedizione(checkbox) {
    if(checkbox.checked == true) {
        var id = checkbox.value;
        var requestUrl ='controller/ecommerce/controllerCarrello.php?operazione=modificaSpedizione&idSpedizione='+id;
        $.ajax({
            url: requestUrl,
            success: function(text) {
                if(text=="ok") {
                  location.reload();
                }
            }
        });
    }
}

function loginPaginaCarrello() {
    var email    = document.getElementById("emailLogin").value;
    var password = document.getElementById("password").value;
    var requestUrl ='controller/ecommerce/controllerAccessi.php?operazione=login&email='+email+'&password='+password;
    $.ajax({
        url: requestUrl,
        success: function(text) {
            if(text=="ok") {
              location.reload();
            }
            else {
		alert("Le credenziali che hai inserito non sono corrette!");
            }
        }
    });
}

/*
 * funzione per effettuare la registrazione dalla pagina carrello
 * viene chiamata quando l'utente ha selezionato la casella crea un account
 */
function registrazionePaginaCarrello(metodoPagamento) {
    var nome      = document.getElementById("nome").value;
    var cognome   = document.getElementById("cognome").value;
    var indirizzo = document.getElementById("via").value;
    var citta     = document.getElementById("citta").value;
    var telefono  = document.getElementById("telefono").value;
    var email     = document.getElementById("email").value;
    var password  = document.getElementById("passwordNuovoUtente").value;
    var partitaIva    = document.getElementById("partitaIva").value;
    var codiceFiscale = document.getElementById("codiceFiscale").value;
    
    var data = {
        operazione:'creaUtenteEInviaMail',
        ruolo:"utente",
        stato:"attivato",
        email:email,
        password:password,
        nome:nome,
        cognome:cognome,
        citta:citta,
        via:indirizzo,
        telefono:telefono,
        partitaIva:partitaIva,
        codiceFiscale:codiceFiscale
    };

    $.ajax({
        url: "areariservata/controller/controllerUtenti.php",
        data:data,
        method: "POST",
	async: false,
        success: function(text) {
            // se non è un numero è un messaggio di errore che deve quindi essere mostrato
            if(isNaN(text)) {
                alert(text);
            }
            else {
                associaCarrelloUtente(text,metodoPagamento);
            }
        },
        error: function(xhr,status,error) {
            alert(status+" "+error);
        }
    });
}

/*
 * funzione per associare il carrello corrente ad un id
 * viene chiamata quando gli utenti 
 */
function associaCarrelloUtente(id,metodoPagamento) {
    var requestUrl ='controller/ecommerce/controllerCarrello.php?operazione=associaCarrelloUtente&id='+id;
    $.ajax({
        url: requestUrl,
        async: false,
        success: function(text) {
            if(text!="ok") {
		alert("c'è un problema col tuo ordine, contatta un amministratore del sito");
            }
        },
	 error: function() {
		alert("si è verificato un errore, contatta il gestore del sito");
	 }
    });
}

function trasformaCarrelloInOrdine() {
    var nome          = document.getElementById("nome").value;
    var cognome       = document.getElementById("cognome").value;
    var email         = document.getElementById("email").value;
    var telefono      = document.getElementById("telefono").value;
    var via           = document.getElementById("via").value;
    var citta         = document.getElementById("citta").value;
    var cap           = document.getElementById("capSpedizione").value;
    var partitaIva    = document.getElementById("partitaIva").value;
    var codiceFiscale = document.getElementById("codiceFiscale").value;
    var opzioniSpedizione = 0;

    if(document.querySelector('input[name="opzioniSpedizione"]:checked')==null) {
	alert("Seleziona il tipo di spedizione");
    }
    else if(document.querySelector('input[name="opzioniPagamento"]:checked')==null) {
	alert("Seleziona il metodo di pagamento");
    }
    else if(nome.length<1) {
	alert("Inserisci il tuo nome, se hai un account effettua il login");
    }
    else if(cognome.length<1) {
	alert("Inserisci il tuo cognome, se hai un account effettua il login");
    }
    else if(email.length<1 || email.indexOf("@")<0 || email.indexOf(".")<0) {
	alert("Inserisci un'email valida, se hai un account effettua il login");
    }
    else if(telefono.length<1) {
	alert("Inserisci un numero di telefono");
    }
    else if(via.length<1) {
	alert("Inserisci la via a cui dobbiamo consegnare, se hai un account effettua il login");
    }
    else if(citta.length<1) {
	alert("Inserisci la città, se hai un account effettua il login");
    }
    else if(opzioniSpedizione==null) {
        alert("Seleziona un metodo di spedizione");
    }
    else {
    	// questa funzione deve essere inserito per prevenire problemi con paypal
        aggiornaLabelCostoCarrelloDaBackend();
            
        // controllo se l'utente ha selezionato la spunta crea un account
        if(document.getElementById("creaAccount")!=undefined && document.getElementById("creaAccount").checked) {
            registrazionePaginaCarrello();
        }
        opzioniSpedizione = document.querySelector('input[name="opzioniSpedizione"]:checked').value;
        var metodoPagamento   = document.querySelector('input[name="opzioniPagamento"]:checked').value;

        // imposto i dati
        var urlRichiesta = "controller/ecommerce/controllerCarrello.php";
        var data = {
            operazione:'convertiInOrdine',
            email:email,
            telefono:telefono,
            nome:nome,
            cognome:cognome,
            via:via,
            citta:citta,
            capSpedizione:cap,
            spedizione:opzioniSpedizione,
            tipoPagamento:metodoPagamento,
            partitaIva:partitaIva,
            codiceFiscale:codiceFiscale,
            tipoRicevuta:'ricevuta'
        };

        $.ajax({
            url: urlRichiesta,
            data: data,
            async: false,
            success: function(text) {
                if(text!="ok") {
                   alert("ci sono stati problemi per eseguire la tua richiesta, riprova tra poco oppure contatta un amministratore");
                }
                else {
                    if(metodoPagamento=="paypal" || metodoPagamento=="stripe") {
                        location.href='paginaPagamento.php'
                    }
                    else {
                        location.href='acquistoEffettuato.php';
                    }
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
}

/*
 * funzione per associare al carrello un buono sconto
 */
function aggiungiBuonoSconto() {
    var buonoSconto  = document.getElementById("buonoSconto").value;
    var urlRichiesta = "controller/ecommerce/controllerCarrello.php";
    var data = {
        operazione:'aggiungiBuonoSconto',
        buonoSconto:buonoSconto
    };

    $.ajax({
        url: urlRichiesta,
        data: data,
        success: function(text) {
            if(text!="ok") {
               alert(text);
               document.getElementById("buonoSconto").value = "";
            }
            else {
               location.reload();
            }
        },
        error: function(xhr,status,error) {
            alert(status+" "+error);
        }
    });
}

function generaSecretStripe(inputId) {
    $.ajax({
        type:"POST",
        url:"controller/azioni/ecommerce/generaSecretStripe.php",
        success:function(code) {
            document.getElementById(inputId).value = code;
        },
        error: function(xhr,status,error) {
            alert(status+" "+error);
        },
        async:false
    });
}

function impostaOrdineStripecomePagatoEdEseguiRedirect(idTransazione) {
    $.ajax({
        type:"POST",
        url:"controller/ecommerce/controllerCarrello.php",
        data:{
            operazione:'impostaOrdineStripePagato',
            idTransazione:idTransazione
        },
        success:function() {
            location.href="acquistoEffettuato.php";
        },
        error: function() {
            alert("Si sono verificati problemi durante la richiesta, riprova tra qualche istante");
        },
        async:false
    });
}

function aggiornaLabelCarrello() {
    var requestUrl ='controller/ecommerce/controllerCarrello.php?operazione=stampaNumeroProdottiCarrello';
    $.ajax({
        url: requestUrl,
        success: function(risultato) {
            document.getElementById("labelNumeroCarrello").innerHTML = risultato;
        }
    });
}

function aggiornaLabelTotaleCarrello(metodoScelto,importoCarrello,importoCarrelloConPagamentoConsegna) {
    
    // se è stato scelto paypal come metodo di pagamento viene scelto paypal fa l'aggiornamento dal database
    if(metodoScelto=="paypal") {
        aggiornaLabelCostoCarrelloDaBackend();
    }
    else if(metodoScelto=="Pagamento alla consegna") {
        document.getElementById("labelTotaleCarrello").innerHTML = importoCarrelloConPagamentoConsegna;
    }
    else {
        document.getElementById("labelTotaleCarrello").innerHTML = importoCarrello;
    }
}

function aggiornaDatiUtenteCarrello() {
    var nome     = document.getElementById("nome").value;
    var cognome  = document.getElementById("cognome").value; 
    var email    = document.getElementById("email").value;
    var telefono = document.getElementById("telefono").value;
    var citta    = document.getElementById("citta").value;
    var indirizzo= document.getElementById("via").value;
    var capSpedizione = document.getElementById("capSpedizione").value;
    var nazione       = document.getElementById("nazione").value;
    var codiceFiscale = document.getElementById("codiceFiscale").value;
    var partitaIva    = document.getElementById("partitaIva").value;
    
    if(isNaN(capSpedizione)) { // se per sbaglio un utente scrive nel cap spedizione qualcosa di diverso da un numero viene messa la stringa vuota
    	capSpedizione = "";
    }
    
    $.ajax({
        async:false,
        type:"POST",
        url: 'controller/ecommerce/controllerCarrello.php',
        data:{
            operazione:'aggiornaDatiUtenteCarrello',
            nome:nome,
            cognome:cognome,
            email:email,
            telefono:telefono,
            indirizzo:indirizzo,
            citta:citta,
            capSpedizione:capSpedizione,
            nazione:nazione,
            codiceFiscale:codiceFiscale,
            partitaIva:partitaIva
        },
        success: function(esito) {
            if(esito!="ok") {
                alert(esito);
            }
        },
        error: function(risultato) {
            alert("Problemi di comunicazione con il server, contatta il gestore del sito");
        },
    });
}

function aggiornaElencoSpedizioniDisponibili() {
    aggiornaDatiUtenteCarrello();
    location.reload();
}

/**
 * questa funzione serve prevenire problemi con paypal, aggiorna i dati del carrello
 * e della form di paypal aggiornandola con i valori presi dal database
 */
function aggiornaLabelCostoCarrelloDaBackend() {
    $.ajax({
        async:false,
        type:"POST",
        url: 'controller/ecommerce/controllerCarrello.php',
        data:{
            operazione:'stampaCostoProdottiETotale'
        },
        success: function(dati) {
            var prezzi = dati.split("-");
            document.getElementById("labelTotaleCarrello").innerHTML = prezzi[1];
            document.getElementById("importoFormPaypal").value       = prezzi[1];
        },
        error: function(risultato) {
            alert("Problemi di comunicazione con il server, contatta il gestore del sito");
        },
    });
}

/*
 * Funzione utilizzata per aggiornare il costo di un prodotto dopo che l'utente ha selezionato la variante
 * Recupera il prezzo dal server e poi aggiorna il valore labelPrezzoProdotto
 */
function aggiornaPrezzoVariante(idProdotto) {
    var idVariante = document.getElementById("variazioneProdotto"+idProdotto).value;

    $.ajax({
        async:false,
        type:"POST",
        url: 'controller/ecommerce/controllerProdotti.php',
        data:{
            operazione:'stampaCostoVariante',
            id:idProdotto,
            idVariante:idVariante
        },
        success: function(esito) {
            document.getElementById("labelPrezzoProdotto").innerHTML = esito;
        },
        error: function(risultato) {
            alert("Problemi di comunicazione con il server, contatta il gestore del sito");
        },
    });
}
